/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.InputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArray;

class BlockedByteArrayInputStream
extends InputStream {
    private BlockedByteArray src;
    private long pos;

    public BlockedByteArrayInputStream(BlockedByteArray blockedByteArray, long l) {
        if (blockedByteArray == null) {
            throw new IllegalArgumentException("BlockedByteArray cannot be null");
        }
        this.src = blockedByteArray;
        this.pos = l;
    }

    void setPosition(long l) {
        this.pos = l;
    }

    long getPosition() {
        return this.pos;
    }

    public int read() {
        int n = this.src.read(this.pos);
        if (n != -1) {
            ++this.pos;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.src.read(this.pos, byArray, n, n2);
        if (n3 != -1) {
            this.pos += (long)n3;
        }
        return n3;
    }

    public void close() {
        this.src = null;
    }
}

